<?php
include __DIR__ . '/../../includes/config.php';

// Cek apakah ada ID
if (!isset($_GET['id'])) {
    die("ID tidak ditemukan.");
}

$id = (int) $_GET['id'];

// Ambil data request
$query = "SELECT r.*, u.name AS student_name, u.email 
          FROM requests r
          JOIN users u ON r.user_id = u.id
          WHERE r.id = $id";
$result = mysqli_query($koneksi, $query);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Data tidak ditemukan.");
}

$data = mysqli_fetch_assoc($result);

// Jika form disubmit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $status = mysqli_real_escape_string($koneksi, $_POST['status']);
    $similarity = mysqli_real_escape_string($koneksi, $_POST['similarity_score']);
    $notes = mysqli_real_escape_string($koneksi, $_POST['admin_notes']);

    $update = "UPDATE requests 
               SET status='$status', 
                   similarity_score='$similarity', 
                   admin_notes='$notes' 
               WHERE id=$id";

    if (mysqli_query($koneksi, $update)) {
        header("Location: index.php");
        exit;
    } else {
        echo "Gagal update: " . mysqli_error($koneksi);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Request</title>
    <style>
        body { font-family: Arial, sans-serif; }
        form { max-width: 500px; margin: 20px auto; }
        label { display: block; margin-top: 10px; }
        input, select, textarea { width: 100%; padding: 8px; margin-top: 5px; }
        button { margin-top: 15px; padding: 8px 15px; }
    </style>
</head>
<body>

<h2>Edit Permintaan Turnitin</h2>

<form method="post">
    <p><b>Judul:</b> <?php echo htmlspecialchars($data['title']); ?></p>
    <p><b>Mahasiswa:</b> <?php echo htmlspecialchars($data['student_name']); ?> (<?php echo htmlspecialchars($data['email']); ?>)</p>

    <label>Status</label>
    <select name="status">
        <option value="Pending" <?php if($data['status']=="Pending") echo "selected"; ?>>Pending</option>
        <option value="In Progress" <?php if($data['status']=="In Progress") echo "selected"; ?>>In Progress</option>
        <option value="Completed" <?php if($data['status']=="Completed") echo "selected"; ?>>Completed</option>
        <option value="Rejected" <?php if($data['status']=="Rejected") echo "selected"; ?>>Rejected</option>
    </select>

    <label>Similarity Score</label>
    <input type="text" name="similarity_score" value="<?php echo htmlspecialchars($data['similarity_score']); ?>">

    <label>Catatan Admin</label>
    <textarea name="admin_notes" rows="4"><?php echo htmlspecialchars($data['admin_notes']); ?></textarea>

    <button type="submit">Simpan</button>
    <a href="index.php">Batal</a>
</form>

</body>
</html>
