<?php
require_once __DIR__ . '/../includes/functions.php';
require_login();
global $pdo;
$user = $_SESSION['user'];
$stmt = $pdo->prepare('SELECT * FROM requests WHERE user_id = ? ORDER BY submitted_at DESC');
$stmt->execute([$user['id']]);
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body>
<nav class="navbar navbar-light bg-white border-bottom"><div class="container">
  <a class="navbar-brand" href="#">Turnitin Request</a>
  <div>
    <span class="me-3">Halo, <?=htmlspecialchars($user['name'])?></span>
    <a href="upload_request.php" class="btn btn-sm btn-primary me-2">Buat Permintaan</a>
    <a href="logout.php" class="btn btn-sm btn-outline-secondary">Logout</a>
  </div>
</div></nav>
<div class="container py-4">
  <h4>Daftar Permintaan</h4>
  <?php if(empty($rows)): ?>
    <div class="alert alert-info">Belum ada permintaan.</div>
  <?php else: ?>
    <table class="table table-striped"><thead><tr><th>#</th><th>Judul</th><th>Tanggal</th><th>Status</th><th>Aksi</th></tr></thead><tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?=htmlspecialchars($r['id'])?></td>
        <td><?=htmlspecialchars($r['title'])?></td>
        <td><?=htmlspecialchars($r['submitted_at'])?></td>
        <td><?=htmlspecialchars($r['status'])?></td>
        <td><a href="request_detail.php?id=<?=intval($r['id'])?>" class="btn btn-sm btn-outline-primary">Lihat</a></td>
      </tr>
    <?php endforeach; ?>
    </tbody></table>
  <?php endif; ?>
</div>
</body></html>
