<?php
require_once __DIR__ . '/../includes/functions.php';
if(session_status() === PHP_SESSION_NONE) session_start();
$error = '';
if($_SERVER['REQUEST_METHOD']=='POST'){
  $u = $_POST['username'] ?? '';
  $p = $_POST['password'] ?? '';
  $user = find_user_by_username($u);
  if($user && password_verify($p, $user['password'])){
    unset($user['password']);
    $_SESSION['user'] = $user;
    if($user['role']=='admin') header('Location: admin/index.php');
    else header('Location: dashboard.php');
    exit;
  } else {
    $error = 'Login gagal — periksa username/password';
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body class="bg-light d-flex align-items-center" style="height:100vh;">

  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-lg border-0 rounded-3">
          <div class="card-header text-center bg-white text-white">

			  			<table width="100%" height="100%">
				<tr>
					<td align="center" valign="middle">
						<img src="image/logo.png" alt="Logo" width="150">
					</td>
				</tr>
			</table>
          </div>
          <div class="card-body p-4">
            <!-- Form login -->
            <form action="" method="post">
              <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" name="username" id="username" class="form-control" required>
              </div>
              <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" name="password" id="password" class="form-control" required>
              </div>
              <div class="d-grid">
                <button type="submit" name="login" class="btn btn-success">Login</button>
				              <a href="register.php" class="btn btn-link">Daftar</a>
              </div>
            </form>
          </div>
          <div class="card-footer text-muted text-center small">
            &copy; <?= date("Y") ?> Sistem Arsip
          </div>
        </div>
      </div>
    </div>
  </div>

</body>
</html>
