<?php
require_once __DIR__ . '/../includes/functions.php';
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $u = trim($_POST['username'] ?? '');
    $p = $_POST['password'] ?? '';
    $n = trim($_POST['name'] ?? '');
    $e = trim($_POST['email'] ?? '');

    if (!$u || !$p || !$n) {
        $error = 'Isi semua field yang diperlukan';
    } elseif (find_user_by_username($u)) {
        $error = 'Username sudah dipakai';
    } else {
        if (register_user($u, $p, $n, $e)) {
            $success = "Registrasi berhasil! Silakan login.";
        } else {
            $error = "Registrasi gagal. Coba lagi.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="height:100vh;">

  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-5">
        <div class="card shadow-lg border-0 rounded-3">
          <div class="card-header text-center bg-white text-black">
            <h4 class="mb-0">Daftar Akun Baru</h4>
          </div>
          <div class="card-body p-4">

            <?php if (!empty($error)): ?>
              <div class="alert alert-danger text-center"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <?php if (!empty($success)): ?>
              <div class="alert alert-success text-center"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>

            <form method="post" action="">
              <div class="mb-3">
                <label for="username" class="form-label">Username *</label>
                <input type="text" name="username" id="username" class="form-control" required>
              </div>

              <div class="mb-3">
                <label for="password" class="form-label">Password *</label>
                <input type="password" name="password" id="password" class="form-control" required>
              </div>

              <div class="mb-3">
                <label for="name" class="form-label">Nama Lengkap *</label>
                <input type="text" name="name" id="name" class="form-control" required>
              </div>

              <div class="mb-3">
                <label for="email" class="form-label">Email (opsional)</label>
                <input type="email" name="email" id="email" class="form-control">
              </div>

              <button type="submit" class="btn btn-primary w-100">Daftar</button>
            </form>

            <div class="text-center mt-3">
              <a href="login.php">Sudah punya akun? Login</a>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>

</body>
</html>
