<?php
require_once __DIR__ . '/../includes/functions.php';
require_login();
$error = '';
if($_SERVER['REQUEST_METHOD']=='POST'){
  if(!isset($_FILES['file'])){ $error = 'File tidak ditemukan'; }
  else {
    $f = $_FILES['file'];
    $allowed = ['application/pdf','application/msword','application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
    if($f['error']===0 && in_array($f['type'],$allowed) && $f['size']<=10*1024*1024){
       $ext = pathinfo($f['name'], PATHINFO_EXTENSION);
       $newname = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
       if(!is_dir(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
       move_uploaded_file($f['tmp_name'], UPLOAD_DIR . $newname);
       global $pdo;
       $stmt = $pdo->prepare('INSERT INTO requests (user_id,title,course,supervisor,description,file_path) VALUES (?,?,?,?,?,?)');
       $stmt->execute([$_SESSION['user']['id'], $_POST['title'], $_POST['course'], $_POST['supervisor'], $_POST['description'], 'uploads/'.$newname]);
       header('Location: dashboard.php?uploaded=1'); exit;
    } else {
       $error = 'Tipe file tidak diizinkan atau ukuran terlalu besar (max 10MB)';
    }
  }
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Upload Request</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body>
<div class="container py-4">
  <h4>Buat Permintaan Pengecekan</h4>
  <?php if($error): ?><div class="alert alert-danger"><?=htmlspecialchars($error)?></div><?php endif; ?>
  <form method="post" enctype="multipart/form-data">
    <div class="mb-3"><label class="form-label">Judul</label><input name="title" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">File (PDF/DOC/DOCX, max 10MB)</label><input type="file" name="file" class="form-control" required></div>
    <div><a href="dashboard.php" class="btn btn-danger">Batal</a> <button class="btn btn-primary">Kirim Permintaan</button></div>
  </form>
</div>
</body></html>
